package it.unicam.pizzeria4.view;

import java.util.Iterator;
import java.util.Scanner;
import java.util.ArrayList;

import it.unicam.pizzeria4.sala.Sala;
import it.unicam.pizzeria4.servizio.GestoreComande;
import it.unicam.pizzeria4.servizio.Menu;
import it.unicam.pizzeria4.util.DettagliMenu;
import it.unicam.pizzeria4.util.DettagliComanda;
import it.unicam.pizzeria4.util.DettagliPortata;
import it.unicam.pizzeria4.util.MenuObserver;

public class ICameriere implements MenuObserver {

	private Sala sala;
	private Menu menu;
	private GestoreComande gComande;
	private ArrayList<DettagliMenu> dettagliMenu;

	private ICameriere() {
		this.sala = Sala.getInstance();
		this.menu = Menu.getInstance();
		this.gComande = GestoreComande.getInstance();		
		dettagliMenu = menu.getPiattiBibiteDisponibili();
	}
	
	public static ICameriere createICameriere() {
		ICameriere cameriere = new ICameriere();
		cameriere.menu.subscribe(cameriere);
		return cameriere;
	}

	public void compilazioneComanda() {
		Iterator<DettagliMenu> dmi = dettagliMenu.iterator();
		System.out.println("MENU DI OGGI");
		String antipasti, primi, secondi, contorni, dolci, bibiteAlcol, bibiteNoAlcol;
		antipasti = primi = secondi = contorni = dolci = bibiteAlcol = bibiteNoAlcol = "";
		DettagliMenu alimento;
		while (dmi.hasNext()) {
			alimento = dmi.next();
			switch (alimento.getTipo()) {
			case antipasto:
				antipasti = antipasti + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - "
						+ alimento.getPrezzo() + "€ " + alimento.getDescrizione() + "\n";
				break;
			case primo:
				primi = primi + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - " + alimento.getPrezzo()
						+ "€ " + alimento.getDescrizione() + "\n";
				break;
			case secondo:
				secondi = secondi + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - "
						+ alimento.getPrezzo() + "€ " + alimento.getDescrizione() + "\n";
				break;
			case contorno:
				contorni = contorni + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - "
						+ alimento.getPrezzo() + "€ " + alimento.getDescrizione() + "\n";
				break;
			case dolce:
				dolci = dolci + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - " + alimento.getPrezzo()
						+ "€ " + alimento.getDescrizione() + "\n";
				break;
			case bibitaAnalcolica:
				bibiteAlcol = bibiteAlcol + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - "
						+ alimento.getPrezzo() + "€ " + alimento.getDescrizione() + "\n";
				break;
			case bibitaAlcolica:
				bibiteNoAlcol = bibiteNoAlcol + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - "
						+ alimento.getPrezzo() + "€ " + alimento.getDescrizione() + "\n";
				break;
			}
		}
		System.out.println("Antipasti:\n" + antipasti);
		System.out.println("Primi:\n" + primi);
		System.out.println("Secondi:\n" + secondi);
		System.out.println("Contorni:\n" + contorni);
		System.out.println("Dolci:\n" + dolci);
		System.out.println("Bibite Alcoliche:\n" + bibiteAlcol);
		System.out.println("Bibite Analcoliche:\n" + bibiteNoAlcol);
	}
	
	public void update() {
		dettagliMenu = menu.getPiattiBibiteDisponibili();
	}

	public void update(ArrayList<DettagliMenu> dMenuNotify) {
		Iterator<DettagliMenu> dmni = dMenuNotify.iterator();
		DettagliMenu currentNotified;
		boolean trovato = false;
		while (dmni.hasNext()) {
			currentNotified = dmni.next();
			Iterator<DettagliMenu> dmi = dettagliMenu.iterator();
			DettagliMenu current;
			trovato=false;
			while (!trovato && dmi.hasNext()) {
				current = dmi.next();
				if (current.getID().equals(currentNotified.getID())) {
					dettagliMenu.remove(current);
					trovato=true;
				}
			}
			if (!trovato) dettagliMenu.add(currentNotified);
		}
	}

	public void compilazioneComanda(Scanner reader) {
		Iterator<DettagliMenu> dmi = dettagliMenu.iterator();
		System.out.println("MENU DI OGGI");
		String antipasti, primi, secondi, contorni, dolci, bibiteAlcol, bibiteNoAlcol;
		antipasti = primi = secondi = contorni = dolci = bibiteAlcol = bibiteNoAlcol = "";
		DettagliMenu alimento;
		while (dmi.hasNext()) {
			alimento = dmi.next();
			switch (alimento.getTipo()) {
			case antipasto:
				antipasti = antipasti + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - "
						+ alimento.getPrezzo() + "€ " + alimento.getDescrizione() + "\n";
				break;
			case primo:
				primi = primi + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - " + alimento.getPrezzo()
						+ "€ " + alimento.getDescrizione() + "\n";
				break;
			case secondo:
				secondi = secondi + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - "
						+ alimento.getPrezzo() + "€ " + alimento.getDescrizione() + "\n";
				break;
			case contorno:
				contorni = contorni + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - "
						+ alimento.getPrezzo() + "€ " + alimento.getDescrizione() + "\n";
				break;
			case dolce:
				dolci = dolci + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - " + alimento.getPrezzo()
						+ "€ " + alimento.getDescrizione() + "\n";
				break;
			case bibitaAnalcolica:
				bibiteAlcol = bibiteAlcol + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - "
						+ alimento.getPrezzo() + "€ " + alimento.getDescrizione() + "\n";
				break;
			case bibitaAlcolica:
				bibiteNoAlcol = bibiteNoAlcol + "ID: " + alimento.getID() + " - " + alimento.getNome() + " - "
						+ alimento.getPrezzo() + "€ " + alimento.getDescrizione() + "\n";
				break;
			}
		}
		System.out.println("Antipasti:\n" + antipasti);
		System.out.println("Primi:\n" + primi);
		System.out.println("Secondi:\n" + secondi);
		System.out.println("Contorni:\n" + contorni);
		System.out.println("Dolci:\n" + dolci);
		System.out.println("Bibite Alcoliche:\n" + bibiteAlcol);
		System.out.println("Bibite Analcoliche:\n" + bibiteNoAlcol);
		boolean continua = true;
		System.out.println("Inserisci l'identificativo del tavolo:");
		String idTavolo = reader.nextLine();
		String idComanda = compilaComandaTavolo(idTavolo);
		if (idComanda.equals(""))
			return;
		String idOrdine;
		int quantita;
		String[] ordine;
		while (continua) {
			System.out.print(
					"Inserisci il codice del piatto o bevanda ordinata e la quantita desiderata (usa spazio per separare):  ");
			ordine = reader.nextLine().split("\\s+");
			if (ordine.length != 2) {
				System.out.println(
						"[ERRORE]: Formato errato. Inserire codice articolo e quantità separati da uno spazio");
				continue;
			}	
			idOrdine = ordine[0];
			quantita = Integer.parseInt(ordine[1]);
			if (idOrdine.charAt(0) == 'b') {

				/*
				 * Al fine di poter trasferire i dati di sessione è importante poter definire un
				 * tipo di dato per tali informazioni. La prossima iterazione si occuperà di
				 * definire tale dato evitando di dover modificare le segnature dei vari metodi.
				 */
				aggiungiBibita(idOrdine, quantita, idComanda);
			} else {
				aggiungiPiatto(idOrdine, quantita, idComanda);
			}
			System.out.println("Vuoi inserire altri alimenti? (S/N)");
			continua = (reader.nextLine().equals("S") ? true : false);
		}
		chiudiComanda(idComanda);
	}

	/**
	 * 
	 * @param idTavolo
	 */
	public String compilaComandaTavolo(String idTavolo) {
		DettagliComanda dettagliComanda = sala.compilaComandaTavolo(idTavolo);
		if (dettagliComanda == null)
			return "";
		System.out.println("ORDINAZIONE PER IL TAVOLO");
		String antipasti, primi, secondi, contorni, dolci, bibiteAlcol, bibiteNoAlcol;
		antipasti = primi = secondi = contorni = dolci = bibiteAlcol = bibiteNoAlcol = "";
		DettagliPortata[] dp = dettagliComanda.getDettagliPortata();
		DettagliMenu ep;
		for (int i = 0; i < dp.length; i++) {
			ep = dp[i].getOrdinazione();
			switch (ep.getTipo()) {
			case antipasto:
				antipasti = antipasti + ep.getNome() + " - " + ep.getPrezzo() + "€" + " - " + dp[i].getQuantita()
						+ "\n";
				break;
			case primo:
				primi = primi + ep.getNome() + " - " + ep.getPrezzo() + "€" + " - " + dp[i].getQuantita() + "\n";
				break;
			case secondo:
				secondi = secondi + " - " + ep.getNome() + " - " + ep.getPrezzo() + "€" + " - " + dp[i].getQuantita()
						+ "\n";
				break;
			case contorno:
				contorni = contorni + " - " + ep.getNome() + " - " + ep.getPrezzo() + "€" + " - " + dp[i].getQuantita()
						+ "\n";
				break;
			case dolce:
				dolci = dolci + " - " + ep.getNome() + " - " + ep.getPrezzo() + "€" + " - " + dp[i].getQuantita()
						+ "\n";
				break;
			case bibitaAnalcolica:
				bibiteAlcol = bibiteAlcol + ep.getNome() + " - " + ep.getPrezzo() + "€" + " - " + dp[i].getQuantita()
						+ "\n";
				break;
			case bibitaAlcolica:
				bibiteNoAlcol = bibiteNoAlcol + ep.getNome() + " - " + ep.getPrezzo() + "€" + " - "
						+ dp[i].getQuantita() + "\n";
				break;
			}
		}
		System.out.println("Antipasti:\n" + antipasti);
		System.out.println("Primi:\n" + primi);
		System.out.println("Secondi:\n" + secondi);
		System.out.println("Contorni:\n" + contorni);
		System.out.println("Dolci:\n" + dolci);
		System.out.println("Bibite Alcoliche:\n" + bibiteAlcol);
		System.out.println("Bibite Analcoliche:\n" + bibiteNoAlcol);
		return dettagliComanda.getIdComanda();
	}

	/**
	 * 
	 * @param idPiatto
	 * @param quantita
	 */
	public void aggiungiPiatto(String idPiatto, int quantita, String idComanda) {
		gComande.aggiungiPiatto(idPiatto, quantita, idComanda);
	}

	/**
	 * 
	 * @param idBibita
	 * @param quantita
	 */
	public void aggiungiBibita(String idBibita, int quantita, String idComanda) {
		gComande.aggiungiBibita(idBibita, quantita, idComanda);

	}

	public void chiudiComanda(String idComanda) {
		gComande.chiudiCreazioneComanda(idComanda);
	}

}
